(function() {
  //    FILE:EventListView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 5/15/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'views/timereport/TimereportDetailView', 'views/menu/MenuView', "views/project/ProjectListView", 'collections/timereport/TimereportCollection', 'collections/project/ProjectCollection', 'collections/event/EventCollection', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, TimereportDetailView, MenuView, ProjectListView, TimereportCollection, ProjectCollection, EventCollection) {
    var TimereportListView;
    return TimereportListView = class TimereportListView extends Backbone.View {
      initialize(usr, obj) {
        this.usr = usr;
        this.obj = obj;
        this.timereportsND = new TimereportCollection();
        this.timereportsRC = new TimereportCollection();
        this.timereportsND.on('timereportNDchanged', this.__update_timereportsND_list, this);
        this.timereportsRC.on('timereportRCchanged', this.__update_timereportsRC_list, this);
        return this.showingList = 'ND';
      }

      attributes() {
        return {
          'data-role': 'page'
        };
      }

      events() {
        return {
          'tap #id-btn-panel': 'btnPanelClicked',
          'tap #id-btn-add-adhoc-tr': 'btnAddAdhocTRClicked',
          'tap .btn-submenu-timereport': 'subMenuTimeReportClicked',
          'tap .ul-timereport > li': 'btnTimeReportClicked',
          'pageshow': 'setMenus'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['TimereportListView'];
        this.$el.html(template({
          user: this.usr.toJSON(),
          canAdhocTimeport: this.__can_adhoc_timereport()
        }));
        this.$el.attr('id', 'id-TimereportListView');
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr, this.obj);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      btnPanelClicked(event) {
        return this.panel.btnPanelClicked(event);
      }

      //#console.log "TIME REPORT COLLECTION UPDATED!! NOW THERE ARE TIMERPOERTs "+col.models.length
      setMenus() {
        var texts;
        this.__get_timereports('ND');
        this.__get_timereports('RC');
        texts = new Object();
        texts.trs = "Timereports";
        if (window.isCompany("rt1.tv")) {
          texts.trs = "Produktionsberichte";
        }
        $('#id-div-header > h1').text(texts.trs);
        if (this.showingList === 'ND') {
          $('#id-submenu-timereport-notdone').addClass('ui-btn-active');
          $('.subTimeReportView').hide();
          return $('#id-divTimeReportNotDone').show();
        } else {
          $('#id-submenu-timereport-recent').addClass('ui-btn-active');
          $('.subTimeReportView').hide();
          return $('#id-divTimeReportRecent').show();
        }
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      subMenuTimeReportClicked(event) {
        var btn, id;
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        if (id === '#id-divTimeReportNotDone') {
          this.showingList = 'ND';
        } else {
          this.showingList = 'RC';
        }
        $('.subTimeReportView').hide();
        return $(id).show();
      }

      btnTimeReportClicked(event) {
        var timereport, timereportCol, tr, trID, type, view;
        event.preventDefault();
        event.stopPropagation();
        tr = $(event.currentTarget);
        trID = tr.attr('data-timereportID');
        type = tr.attr('data-type');
        if (type === 'ND') {
          timereport = this.timereportsND.find_timereport_by_id(trID);
          timereportCol = this.timereportsND;
        } else {
          timereport = this.timereportsRC.find_timereport_by_id(trID);
          timereportCol = this.timereportsRC;
        }
        if (!TimereportDetailView) {
          TimereportDetailView = require('views/timereport/TimereportDetailView');
        }
        view = new TimereportDetailView(this.usr, timereport, timereportCol, null, null, this.obj, type);
        timereport.get_details_timereport(this.usr.get('sessionID'));
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      btnAddAdhocTRClicked(event) {
        var eventsCol, projectCol, timereportsCol, view;
        event.preventDefault();
        event.stopPropagation();
        // CHECK PARAMETERS FOR PROJECTLISTVIEW
        projectCol = new ProjectCollection();
        projectCol.get_projects(this.usr);
        if (!ProjectListView) {
          ProjectListView = require("views/project/ProjectListView");
        }
        timereportsCol = new TimereportCollection();
        eventsCol = new EventCollection();
        view = new ProjectListView(this.usr, projectCol, 'Adhoc', timereportsCol, this.obj, Moment(), eventsCol);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      __update_timereportsRC_list() {
        var ul;
        ul = $('#id-ul-timereportRC');
        ul.empty();
        this.timereportsRC.each(function(tr) {
          var cName, day, li, pT, timereportID;
          pT = tr.get('parentTitle');
          cName = tr.get('clientCompanyName');
          timereportID = tr.cid;
          day = tr.get('day');
          li = `<li  class=\"li-timereport \" data-timereportID=\"${timereportID}\" data-type='RC'>`;
          li += `<span class=\"header\">${pT}</span>`;
          if (cName) {
            li += `<span class=\"subheader1\">${cName}</span>`;
          }
          li += "<span class='fwi-arrow-right arrow-right'/>";
          li += `<span class='day'>${Handlebars.helpers.beautyDate(day)}</span>`;
          li += "</li>";
          return ul.append(li);
        });
        return ul.listview('refresh');
      }

      __update_timereportsND_list() {
        var str, ul;
        //console.log 'CHANGEDDD EVENT '
        ul = $('#id-ul-timereportND');
        ul.empty();
        str = "&nbsp;" + this.timereportsND.models.length + "&nbsp;";
        $('.bubble-timereports').html(str);
        this.timereportsND.each(function(tr) {
          var cName, day, li, pT, timereportID;
          pT = tr.get('parentTitle');
          cName = tr.get('clientCompanyName');
          timereportID = tr.cid;
          day = tr.get('day');
          li = `<li class=\"li-timereport\" data-timereportID=\"${timereportID}\" data-type='ND'>`;
          li += `<span class=\"header\">${pT}</span>`;
          if (cName) {
            li += `<span class=\"subheader1\">${cName}</span>`;
          }
          li += "<span class='fwi-arrow-right arrow-right'/>";
          li += `<span class='day'>${Handlebars.helpers.beautyDate(day)}</span> `;
          li += "</li>";
          return ul.append(li);
        });
        return ul.listview('refresh');
      }

      __get_timereports(type) {
        if (type === 'ND') {
          return this.timereportsND.get_not_done_timereports(this.usr);
        } else if (type === 'RC') {
          return this.timereportsRC.get_recent_timereports(this.usr);
        }
      }

      __can_adhoc_timereport() {
        return this.usr.__can_timereport_all_projects() || this.usr.__can_timereport_in_his_division_projects() || this.usr.__can_timereport_relation_projects() || this.usr.__enabled_time_travel_expenses();
      }

    };
  });

}).call(this);
